package nemosofts.voxradio.activity;

import android.os.Bundle;
import android.view.MenuItem;
import android.widget.SeekBar;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.appcompat.widget.Toolbar;
import androidx.nemosofts.AppCompat;
import androidx.nemosofts.AppCompatActivity;
import androidx.nemosofts.view.SwitchButton;

import nemosofts.voxradio.R;
import nemosofts.voxradio.utils.IfSupported;
import nemosofts.voxradio.utils.SharedPref;

public class SettingDriveModeActivity extends AppCompatActivity {

    private SharedPref sharedPref;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        sharedPref = new SharedPref(this);
        super.onCreate(savedInstanceState);

        IfSupported.IsRTL(this);
        IfSupported.IsScreenshot(this);

        Toolbar toolbar = findViewById(R.id.toolbar_setting);
        setSupportActionBar(toolbar);
        toolbar.setTitle(getResources().getString(R.string.settings));
        if (getSupportActionBar() != null) {
            getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            getSupportActionBar().setDisplayShowHomeEnabled(true);
            toolbar.setNavigationOnClickListener(view -> onBackPressed());
        }

        SwitchButton switch_drive_color = findViewById(R.id.switch_drive_color);
        switch_drive_color.setChecked(sharedPref.isDriveColor());
        switch_drive_color.setOnCheckedChangeListener((view, isChecked) -> sharedPref.setDriveColor(isChecked));

        SwitchButton switch_snow_fall = findViewById(R.id.switch_drive_snow_fall);
        switch_snow_fall.setChecked(sharedPref.isDriveSnowFall());
        switch_snow_fall.setOnCheckedChangeListener((view, isChecked) -> sharedPref.setDriveSnowFall(isChecked));

        SwitchButton switch_keep_screen = findViewById(R.id.switch_keep_screen);
        switch_keep_screen.setChecked(sharedPref.isDriveKeepScreen());
        switch_keep_screen.setOnCheckedChangeListener((view, isChecked) -> sharedPref.setDriveKeepScreen(isChecked));

        TextView tv_blur = findViewById(R.id.tv_blur);
        SeekBar sb_blur = findViewById(R.id.sb_blur);
        sb_blur.setMax(15);
        sb_blur.setProgress(sharedPref.getBlurAmountDrive());
        tv_blur.setText(String.valueOf(sharedPref.getBlurAmountDrive()));
        sb_blur.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                tv_blur.setText(String.valueOf(progress));
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {

            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {
                int progress = seekBar.getProgress();
                sharedPref.setBlurAmountDrive(progress);
                tv_blur.setText(String.valueOf(progress));
            }
        });
    }

    @Override
    public int setLayoutResourceId() {
        return R.layout.activity_setting_drive_mode;
    }

    @Override
    public int setAppCompat() {
        return AppCompat.COMPAT();
    }

    @Override
    public boolean onOptionsItemSelected(@NonNull MenuItem menuItem) {
        if (menuItem.getItemId() == android.R.id.home) {
            onBackPressed();
        } else {
            return super.onOptionsItemSelected(menuItem);
        }
        return true;
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
    }
}